// WarningsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "rwexp.h"
#include "WarningsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWarningsDlg dialog


CWarningsDlg::CWarningsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWarningsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWarningsDlg)
	//}}AFX_DATA_INIT
}

void CWarningsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWarningsDlg)
	DDX_Control(pDX, IDC_WARNINGSLISTVIEW, m_listview);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWarningsDlg, CDialog)
	//{{AFX_MSG_MAP(CWarningsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWarningsDlg message handlers


BOOL CWarningsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

    m_ImageList.Create(16, 16, ILC_COLOR8, 0, 4);
    m_ImageList.Add(AfxGetApp()->LoadIcon(IDI_INFORMATIONALICON));
    m_ImageList.Add(AfxGetApp()->LoadIcon(IDI_WARNINGICON));
    m_ImageList.Add(AfxGetApp()->LoadIcon(IDI_ERRORICON));

   //only do this list view stuff under the report view
   // Insert a column. This override is the most convenient.
   m_listview.InsertColumn(0, _T("Node Name"), LVCFMT_LEFT);

   // The other InsertColumn() override requires an initialized
   // LVCOLUMN structure.
   LVCOLUMN col;
   col.mask = LVCF_FMT | LVCF_TEXT;
   col.pszText = _T("Information");
   col.fmt = LVCFMT_LEFT;
   m_listview.InsertColumn(1, &col);

   // Set reasonable widths for our columns
   m_listview.SetColumnWidth(0, 150);
   m_listview.SetColumnWidth(1, 400);

	m_listview.SetImageList(&m_ImageList,LVSIL_SMALL);

	// TODO: Add extra initialization here
    for (int i=0; i<wlist->getNumWarnings(); i++) {
        int IconNumber;
        switch (wlist->getElement(i).getType()) {
            case wtInformational : IconNumber=0; break;
            case wtWarning       : IconNumber=1; break;
            case wtError         : IconNumber=2; break;
            default              : IconNumber=2; break;
        }
        m_listview.InsertItem(i,wlist->getElement(i).getNodeName(),IconNumber);
        m_listview.SetItemText(i, 1, wlist->getElement(i).getMessage());
    }
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CWarningsDlg::setWarningsList( WarningList *wl )
{
    wlist=wl;
}
